/**
 * vue-coerce-props v1.0.0
 * (c) 2018 Eduardo San Martin Morote <posva13@gmail.com>
 * @license MIT
 */

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.VueCoerceProps = factory());
}(this, (function () { 'use strict';

var index = {
  beforeCreate: function beforeCreate () {
    var ref = this.$options;
    var props = ref.props;
    if (!props) { return }

    this._$coertions = Object.keys(props)
      .filter(function (k) { return props[k].coerce; })
      .map(function (k) { return [k, props[k].coerce]; });
  },

  computed: {
    $coerced: function $coerced () {
      var this$1 = this;

      return this._$coertions.reduce(function (c, ref) {
        var k = ref[0];
        var coerce = ref[1];

        c[k] = coerce.call(this$1, this$1.$props[k]);
        return c
      }, {})
    },
  },
};

return index;

})));
