<?php

namespace App\Traits\Providers;

use App\Helpers\Core as Helper;
use App\Models\Game;
use App\Models\Provider;
use App\Models\GamesKey;
use App\Models\GGRGames;
use App\Models\Order;
use App\Models\User;
use App\Models\Wallet;
use App\Traits\Missions\MissionTrait;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Telegram;

trait EvergameTrait
{
    use MissionTrait;

    /**
     * @var string
     */
    protected static $agentCode;
    protected static $agentToken;
    protected static $agentSecretKey;
    protected static $apiEndpoint;

    public static function getCredentialsEvergame(): bool
    {
        $setting = GamesKey::first();

        self::$agentCode        = $setting->getAttributes()['evergame_agent_code'];
        self::$agentToken       = $setting->getAttributes()['evergame_agent_token'];
        self::$apiEndpoint      = $setting->getAttributes()['evergame_api_endpoint'];

        return true;
    }

    public static function UpdateRTPEvergame($rtp, $provider)
    {
        if (self::getCredentialsEvergame()) {
            $postArray = [
                "method"        => "control_rtp",
                "agentCode"    => self::$agentCode,
                "token"   => self::$agentToken,
                "vendorCode" => $provider,
                "userCode"     => auth('api')->id() . '',
                "rtp"           => $rtp
            ];

            $response = Http::post(self::$apiEndpoint, $postArray);

            if ($response->successful()) {
                // Handle successful response
            }
        }
    }

    public static function createUserEvergame()
    {
        if (self::getCredentialsEvergame()) {
            $postArray = [
                "method"        => "createUser",
                "agentCode"    => self::$agentCode,
                "token"   => self::$agentToken,
                "userCode"     => auth('api')->id() . '',
            ];

            $response = Http::post(self::$apiEndpoint, $postArray);

            if ($response->successful()) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static function GameLaunchEvergame($provider_code, $game_code, $lang, $userId)
    {
        if (self::getCredentialsEvergame()) {
            $postArray = [
                "method"        => "GetGameUrl",
                "agentCode"    => self::$agentCode,
                "token"   => self::$agentToken,
                "userCode"     => $userId . '',
                "vendorCode" => $provider_code,
                "gameCode"     => $game_code,
                "lang"          => $lang
            ];

            $response = Http::post(self::$apiEndpoint, $postArray);
            $data = $response->json();

            if ($data['status'] == 5) {
                if ($data['msg'] == 'INVALID_USER') {
                    if (self::createUserEvergame()) {
                        return self::GameLaunchEvergame($provider_code, $game_code, $lang, $userId);
                    }
                }
            } else {
                if ($provider_code == "Evolution_Casino") {
                    $data['launchUrl'] = $data['launchUrl'] . "&game_id=" . $game_code;
                }

                return $data;
            }
        }
    }

    public static function getFiversUserDetailEvergame()
    {
        if (self::getCredentialsEvergame()) {
            $dataArray = [
                "method"        => "call_players",
                "agentCode"    => self::$agentCode,
                "token"   => self::$agentToken,
            ];

            $response = Http::post(self::$apiEndpoint, $dataArray);

            if ($response->successful()) {
                $data = $response->json();
                dd($data);
            } else {
                return false;
            }
        }
    }

    public static function getBalanceEvergame()
    {
        if (self::getCredentialsEvergame()) {
            $dataArray = [
                "method"        => "money_info",
                "agentCode"    => self::$agentCode,
                "token"   => self::$agentToken,
            ];

            $response = Http::post(self::$apiEndpoint, $dataArray);

            if ($response->successful()) {
                $data = $response->json();
                return $data['agent']['balance'] ?? 0;
            } else {
                return false;
            }
        }
    }

    private static function GetBalanceInfoEvergame($request)
    {
        $wallet = Wallet::where('user_id', $request->userCode)->where('active', 1)->first();
        if (!empty($wallet) && $wallet->total_balance > 0) {
            return response()->json([
                'balance' => $wallet->total_balance,
                'msg' => "SUCCESS"
            ]);
        }

        return response()->json([
            'balance' => 0,
            'msg' => "INSUFFICIENT_USER_FUNDS"
        ]);
    }

    private static function SetTransactionEvergame($request)
    {
        $data = $request->all();
        $wallet = Wallet::where('user_id', $data['userCode'])->where('active', 1)->first();

        if (!empty($wallet)) {
            if (isset($data['userCode'])) {
                $amount = floatval($data['amount']);

                if ($amount < 0) {
                    $bet = abs($amount);
                    $win = 0;
                } else {
                    $bet = 0;
                    $win = $amount;
                }

                if ($bet == 0 && $win == 0) {
                    return response()->json([
                        "status" => 0,
                        "balance" => floatval(number_format($wallet->total_balance, 2, '.', '')),
                        "msg" => "SUCCESS",
                    ]);
                }

                $game = Game::where('game_id', $data['gameCode'])->first();
                $provider = Provider::where('id', $game->provider_id)->first();

                self::CheckMissionExist($data['userCode'], $game);

                $changeBonus = Helper::DiscountBalance($wallet, $bet);
                if ($changeBonus != 'no_balance') {
                    return self::PrepareTransactionsEvergame($wallet, $data['userCode'], $data['txnCode'], $bet, $win, $game->game_name, $provider->code, $changeBonus, $data['txnType']);
                } else {
                    return false;
                }
            }
        }
    }

    private static function PrepareTransactionsEvergame($wallet, $userCode, $txnId, $betMoney, $winMoney, $gameCode, $providerCode, $changeBonus, $txnType)
    {
        $user = User::find($wallet->user_id);
        $beforeAmount = $wallet->balance + $wallet->balance_withdrawal + $wallet->balance_bonus;

        if ($winMoney > $betMoney) {
            $transaction = self::CreateTransactionsEvergame($userCode, time(), $txnId, 'check', $changeBonus, $winMoney, $gameCode, $gameCode);

            if (!empty($transaction)) {
                GGRGames::create([
                    'user_id' => $userCode,
                    'provider' => $providerCode,
                    'game' => $gameCode,
                    'balance_bet' => $betMoney,
                    'balance_win' => $winMoney,
                    'currency' => $wallet->currency,
                    'aggregator' => "evergame",
                    "type" => "win"
                ]);

                Helper::generateGameHistory($user->id, 'win', $winMoney, $betMoney, $changeBonus, $transaction->transaction_id, $gameCode);

                $wallet = Wallet::where('user_id', $wallet->user_id)->where('active', 1)->first();
                $afterAmount = $wallet->balance + $wallet->balance_withdrawal + $wallet->balance_bonus;

                self::sendGameRoundNotification($user, $beforeAmount, $afterAmount, $gameCode, $betMoney);

                return response()->json([
                    "status" => 0,
                    "balance" => floatval(number_format($wallet->total_balance, 2, '.', '')),
                    "msg" => "SUCCESS",
                ]);
            }
        } else {
            $checkTransaction = Order::where('transaction_id', $txnId)->first();
            if (empty($checkTransaction)) {
                $checkTransaction = self::CreateTransactionsEvergame($userCode, time(), $txnId, 'check', $changeBonus, $betMoney, $gameCode, $gameCode);
            }

            GGRGames::create([
                'user_id' => $userCode,
                'provider' => $providerCode,
                'game' => $gameCode,
                'balance_bet' => $betMoney,
                'balance_win' => $winMoney,
                'currency' => $wallet->currency,
                'aggregator' => "evergame",
                "type" => "loss"
            ]);

            Helper::generateGameHistory($user->id, 'bet', $winMoney, $betMoney, $changeBonus, $txnId, $gameCode);

            $wallet = Wallet::where('user_id', $wallet->user_id)->where('active', 1)->first();
            $afterAmount = $wallet->balance + $wallet->balance_withdrawal + $wallet->balance_bonus;

            self::sendGameRoundNotification($user, $beforeAmount, $afterAmount, $gameCode, $betMoney);

            return response()->json([
                "status" => 0,
                "balance" => floatval(number_format($wallet->total_balance, 2, '.', '')),
                "msg" => "SUCCESS",
            ]);
        }
    }

    private static function sendGameRoundNotification($user, $beforeAmount, $afterAmount, $gameCode, $betMoney)
    {
        $dateTime = Carbon::now();
        $date = $dateTime->format('d/m/Y');
        $time = $dateTime->format('H:i:s');
        Log::info("Enviando notificação de nova rodada para o usuário {$user->name}");
        Telegram::sendGameRoundNotification($user->name, $user->email, $date, $time, $gameCode, $beforeAmount, $afterAmount, $betMoney);
    }

    public static function WebhooksEvergame($request)
    {
        switch ($request->method) {
            case "GetBalance":
                return self::GetBalanceInfoEvergame($request);
            case "ChangeBalance":
                return self::SetTransactionEvergame($request);
            default:
                return response()->json(['status' => 0]);
        }
    }

    private static function CreateTransactionsEvergame($playerId, $betReferenceNum, $transactionID, $type, $changeBonus, $amount, $game, $pn)
    {
        $order = Order::create([
            'user_id'       => $playerId,
            'session_id'    => $betReferenceNum,
            'transaction_id'=> $transactionID,
            'type'          => $type,
            'type_money'    => $changeBonus,
            'amount'        => $amount,
            'providers'     => 'Evergame',
            'game'          => $game,
            'game_uuid'     => $pn,
            'round_id'      => 1,
        ]);

        if ($order) {
            return $order;
        }

        return false;
    }

    public static function getProviderEvergame()
    {
        if (self::getCredentialsEvergame()) {
            $response = Http::post(self::$apiEndpoint, [
                'method' => 'GetVendors',
                'agentCode' => self::$agentCode,
                'token' => self::$agentToken
            ]);

            if ($response->successful()) {
                $data = $response->json();

                if (isset($data['vendors'])) {
                    foreach ($data['vendors'] as $vendor) {
                        $cleanedName = explode('_', $vendor['vendorCode'])[0];
                        $checkProvider = Provider::where('code', $vendor['vendorCode'])->where('distribution', 'evergame')->first();
                        if (empty($checkProvider)) {
                            $dataProvider = [
                                'code' => $vendor['vendorCode'],
                                'name' => $cleanedName,
                                'rtp' => 80,
                                'status' => 1,
                                'distribution' => 'evergame',
                            ];
                            Provider::create($dataProvider);
                            echo "provedor criado com sucesso \n";
                        }
                    }
                }
                usleep(6000000); // Pausa de 1 segundo (1.000.000 microssegundos)
            }
        }
    }

    public static function getGamesEvergame()
    {
        if (self::getCredentialsEvergame()) {
            $providers = Provider::where('distribution', 'evergame')->get();

            foreach ($providers as $provider) {
                $response = Http::post(self::$apiEndpoint, [
                    'method' => 'GetVendorGames',
                    'agentCode' => self::$agentCode,
                    'token' => self::$agentToken,
                    'vendorCode' => $provider['code']
                ]);

                if ($response->successful()) {
                    $data = $response->json();

                    if (isset($data['vendorGames'])) {
                        foreach ($data['vendorGames'] as $game) {
                            $gameName = str_replace('_', ' ', json_decode($game['gameName'], true)['en']);
                            $existingGame = Game::where('game_id', $game['gameCode'])->where('distribution', 'evergame')->first();

                            if (empty($existingGame)) {
                                if (!empty($game['imageUrl'])) {
                                    $imageUrl = json_decode($game['imageUrl'], true)['en'];
                                    $image = self::uploadFromUrlEverGame($imageUrl, $game['gameCode']);
                                } else {
                                    $image = null;
                                }

                                if (!empty($game['gameCode']) && !empty($gameName)) {
                                    $data = [
                                        'provider_id'   => $provider->id,
                                        'game_id'       => $game['gameCode'],
                                        'game_code'     => $game['gameCode'],
                                        'game_name'     => $gameName,
                                        'technology'    => 'html5',
                                        'distribution'  => 'evergame',
                                        'rtp'           => 80,
                                        'cover'         => $image,
                                        'status'        => 1,
                                    ];

                                    Game::create($data);
                                    echo "jogo salvo com sucesso \n";
                                }
                            }
                        }
                    }
                }

                usleep(5000000); // Pausa de 1 segundo (1.000.000 microssegundos)
            }
        }
    }

    private static function uploadFromUrlEverGame($url, $name = null)
    {
        try {
            $client = new \GuzzleHttp\Client();
            $response = $client->get($url);

            if ($response->getStatusCode() === 200) {
                $fileContent = $response->getBody();
                $parsedUrl = parse_url($url);
                $pathInfo = pathinfo($parsedUrl['path']);
                $fileName  = $name ?? $pathInfo['filename'];
                $extension = $pathInfo['extension'] ?? 'png';
                $fileName = 'ever/' . $fileName . '.' . $extension;
                Storage::disk('public')->put($fileName, $fileContent);
                return $fileName;
            }

            return null;
        } catch (\Exception $e) {
            return null;
        }
    }
}
